from collections import defaultdict
import pickle
import paramiko
import stat
import os
import pydicom
import datetime
from datetime import datetime
from urllib.request import Request, urlopen
from stat import S_ISDIR
import sys



def ParsingDcm(filename_dcm):
    # filename_dcm = '/Users/yskim/local_dcm/test.dcm'

    dataset = pydicom.dcmread(filename_dcm,force=True)

    #pat_name = dataset.PatientName
    #display_name = pat_name.family_name + ", " + pat_name.given_name

    #print("Patient's name...:", display_name)
    #print("Patient id.......:", dataset.PatientID)
    #print("Modality.........:", dataset.Modality)
    #print("Study Date.......:", dataset.StudyDate)

    #if 'PixelData' in dataset:
    #   rows = int(dataset.Rows)
    #   cols = int(dataset.Columns)
    #   print("Image size.......: {rows:d} x {cols:d}, {size:d} bytes".format(
    #       rows=rows, cols=cols, size=len(dataset.PixelData)))
    #   if 'PixelSpacing' in dataset:
    #       print("Pixel spacing....:", dataset.PixelSpacing)
    return dataset.Modality


def recursive_ftp(sftp, path, files=None):
    global key

    key = path
    if files is None:
        files = defaultdict(list)

    # loop over list of SFTPAttributes (files with modes)
    for attr in sftp.listdir_attr(path):

        if stat.S_ISDIR(attr.st_mode):
            # If the file is a directory, recurse it
            recursive_ftp(sftp, os.path.join(path,attr.filename), files)
            print(path)
        else:
            #  if the file is a file, add it to our dict
            files[path].append(os.path.join(path,attr.filename))
            key=path

    return files,key




def readConvertLog():
    log_path='/mod/dev/backend/apiroot/pacs/'
    hid='am53'
    data_check_file = log_path + "convertdata_" + hid + "_" + today + ".data"
    print(data_check_file)
    if os.path.exists(data_check_file):
        file = open(data_check_file, "rb")
        read_dcm_dic = pickle.load(file)
        print(read_dcm_dic)
    else:
        read_dcm_dic = {}
    return read_dcm_dic

def WriteConvertLog(file_date, read_dcm_dic, filename):
    global total_count

    log_path='/mod/dev/backend/apiroot/pacs/'
    hid='am53'

    read_dcm_dic['last_mtime'] = file_date
    read_dcm_dic['last_filename'] = filename
    read_dcm_dic['total_count'] = total_count

    data_check_file = log_path + "convertdata_" + hid + "_" + today + ".data"

    file = open(data_check_file, "wb")
    pickle.dump(read_dcm_dic, file)
    file.close()

def request(url, read_dcm_dic, gendate, file_date):
    try:
        response = urlopen(url)
        byte_data = response.read()
        text_data = byte_data.decode('utf-8')
        WriteConvertLog(file_date, read_dcm_dic, gendate)
        return text_data

    except IOError:
        return 0

def sftp_walk(remotepath):
    path=remotepath
    files=[]
    folders=[]
    for f in sftp.listdir_attr(remotepath):
        if S_ISDIR(f.st_mode):
            folders.append(f.filename)
        else:
            files.append(f.filename)
    if files:
        yield path, files
    for folder in folders:
        new_path=os.path.join(remotepath,folder)
        for x in sftp_walk(new_path):
            yield x



def receivetodcm(read_dcm_dic, inputDate,workDate):
    global sftp
    global total_count
    sftpURL = '172.16.1.121'
    sftpPORT = 2222
    sftpUser = 'mod'
    sftpPass = 'Tv1234!@'
    remote_url ='/Pacs_Backup/'


    gendate=str(workDate.strftime('%Y%m%d'))
    gendate_ym=str(workDate.strftime('%Y%m'))
    gendate_d=str(workDate.strftime('%d'))

    find_path = remote_url+gendate_ym+'/'+gendate_d
    print('nas path:'+find_path)


    transport = paramiko.Transport((sftpURL,sftpPORT))
    transport.connect(username=sftpUser, password=sftpPass)
    sftp = paramiko.SFTPClient.from_transport(transport)

    #find_path='/Pacs_Backup/20210426/00001204_^문난희^^/' 
    for path, files in sftp_walk(find_path):
        for file in files:
            # sftp.get(remote, local) line for dowloading.
            #sftp.get(os.path.join(os.path.join(path, file)), '/Users/yskim/local_dcm/')
            print(os.path.join(path, file))
            dcmURL=os.path.join(path, file)

            ext = os.path.splitext(dcmURL)[-1]
            name = os.path.splitext(dcmURL)[0]
            print(name + '|' + ext)

            if(ext == '.dcm'):
                dcm_file = sftp.open(dcmURL)

                sftpattrs = sftp.stat(dcmURL)
                print(sftpattrs.st_mtime)
                fileMtime = datetime.fromtimestamp(sftpattrs.st_mtime)

                file_date = str(fileMtime.strftime('%Y-%m-%d %H:%M:%S'))

                #modality = ParsingDcm(dcm_file)
                #print(modality)
                filename = os.path.basename(dcmURL)
                localpath = '/mod/dev/backend/apiroot/pacs/data/am53/dcm/'+gendate+'/' + filename
                print('localpath:' + localpath)

                if inputDate < fileMtime:
                    sftp.get(dcmURL, localpath)
                    #sftp.get(os.path.join(os.path.join(path, file)), '/Users/yskim/local_dcm/')

                    print('새로운 DCM 파일을 복사하였습니다.[' + str(file_date) + '] totalcount:'+str(total_count))


                    # convert_check.php 실행 (데이터베이스에  전송파일명 저장)
                    print("to write databse")
                    # to write remote server's database
                    hid='am53'
                    db_url='http://am53.modhospital.kr:7002/pacs/convert_check.php'
                    request(db_url + "?localdcm="+"&remotedcm=" + localpath + "&gendate=" + gendate + "&hid=" + hid,
                        read_dcm_dic, gendate, file_date)
                    print("file copy success!")
                    print(db_url + "?localdcm=" + localpath + "&remotedcm=" + dcmURL + "&gendate=" + gendate + "&hid=" + hid)


                    total_count += 1




    sftp.close()
    transport.close()


def main(input_date):
    global total_count
    global today

    #20210829
    #input_date = sys.argv[1]
    print('입력된 날짜:'+input_date)

    # 현재일 계산
    # current_datetime = datetime.now()
    # now = datetime(2020, 9, 16, 00, 00, 00)
    input_y = int(input_date[0:4]) #2021
    input_m = int(input_date[4:6])
    input_d = int(input_date[6:8])

    current_datetime = datetime(input_y, input_m, input_d, 00, 00, 00)
    work_day = str(input_y)+"-"+str(input_m)+"-"+str(input_d)+" 00:00:00" 



    today = str(current_datetime.strftime('%Y%m%d'))
    today_Y = int(current_datetime.strftime('%Y'))
    today_M = int(current_datetime.strftime('%m'))
    today_D = int(current_datetime.strftime('%d'))

    now = datetime(today_Y, today_M, today_D, 00, 00, 00)

    read_dcm_dic = readConvertLog()
    print('convert log file find')

    last_file_date = read_dcm_dic.get('last_mtime')
    get_total_count = read_dcm_dic.get('total_count')


    if get_total_count == None:
        total_count = 0

    else:
        total_count = int(get_total_count)

    if last_file_date == None:

        #work_day = str(now.s4rftime('%Y-%m-%d %H:%M:%S'))

        #work_day = "2021-07-29 00:00:00" #test
        workDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')
        inputDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')


    else:
        #work_day = str(now.strftime('%Y-%m-%d %H:%M:%S'))

	#work_day = "2021-07-29 00:00:00" #test
        workDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')

        inputDate = datetime.strptime(last_file_date, '%Y-%m-%d %H:%M:%S')





    #현재날짜 또는 마지막 업데이트 기록을 근거로 새로운 dcm 파일만 가져온다.
    receivetodcm(read_dcm_dic,inputDate,workDate)

input_date = sys.argv[1]
main(input_date )
