from collections import defaultdict
import pickle
import paramiko
import stat
import os
import pydicom
import datetime
from datetime import datetime
from urllib.request import Request, urlopen


def ParsingDcm(filename_dcm):
    # filename_dcm = '/Users/yskim/local_dcm/test.dcm'

    dataset = pydicom.dcmread(filename_dcm,force=True)

    #pat_name = dataset.PatientName
    #display_name = pat_name.family_name + ", " + pat_name.given_name

    #print("Patient's name...:", display_name)
    #print("Patient id.......:", dataset.PatientID)
    #print("Modality.........:", dataset.Modality)
    #print("Study Date.......:", dataset.StudyDate)

    #if 'PixelData' in dataset:
    #   rows = int(dataset.Rows)
    #   cols = int(dataset.Columns)
    #   print("Image size.......: {rows:d} x {cols:d}, {size:d} bytes".format(
    #       rows=rows, cols=cols, size=len(dataset.PixelData)))
    #   if 'PixelSpacing' in dataset:
    #       print("Pixel spacing....:", dataset.PixelSpacing)
    return dataset.Modality


def recursive_ftp(sftp, path, files=None):
    global key

    key = path
    if files is None:
        files = defaultdict(list)

    # loop over list of SFTPAttributes (files with modes)
    for attr in sftp.listdir_attr(path):

        if stat.S_ISDIR(attr.st_mode):
            # If the file is a directory, recurse it
            recursive_ftp(sftp, os.path.join(path,attr.filename), files)
            print(path)
        else:
            #  if the file is a file, add it to our dict
            files[path].append(os.path.join(path,attr.filename))
            key=path

    return files,key




def readConvertLog():
    log_path='/mod/dev/backend/apiroot/pacs/'
    hid='am53'
    data_check_file = log_path + "convertdata_" + hid + "_" + today + ".data"
    print(data_check_file)
    if os.path.exists(data_check_file):
        file = open(data_check_file, "rb")
        read_dcm_dic = pickle.load(file)
        print(read_dcm_dic)
    else:
        read_dcm_dic = {}
    return read_dcm_dic

def WriteConvertLog(file_date, read_dcm_dic, filename):
    global total_count

    log_path='/mod/dev/backend/apiroot/pacs/'
    hid='am53'

    read_dcm_dic['last_mtime'] = file_date
    read_dcm_dic['last_filename'] = filename
    read_dcm_dic['total_count'] = total_count

    data_check_file = log_path + "convertdata_" + hid + "_" + today + ".data"

    file = open(data_check_file, "wb")
    pickle.dump(read_dcm_dic, file)
    file.close()

def request(url, read_dcm_dic, gendate, file_date):
    try:
        response = urlopen(url)
        byte_data = response.read()
        text_data = byte_data.decode('utf-8')
        WriteConvertLog(file_date, read_dcm_dic, gendate)
        return text_data

    except IOError:
        return 0


def receivetodcm(sftp,read_dcm_dic, inputDate,workDate):
    global total_count
    sftpURL = '172.16.1.121'
    sftpPORT = 2222
    sftpUser = 'mod'
    sftpPass = 'Tv1234!@'
    remote_url ='/Pacs_Backup/'


    gendate=str(workDate.strftime('%Y%m%d'))


    #find_path = remote_url+gendate+'/'
    find_path = '/Pacs_Backup/20210514/00000059_^임복실^^/'
    print('nas path:'+find_path)


    transport = paramiko.Transport((sftpURL, sftpPORT))
    transport.connect(username=sftpUser, password=sftpPass)
    sftp = paramiko.SFTPClient.from_transport(transport)
    files,key = recursive_ftp(sftp,find_path)
    print(key)
    dcm_list = files[key]

    print(dcm_list)

    for dcmURL in dcm_list:
        ext = os.path.splitext(dcmURL)[-1]
        name = os.path.splitext(dcmURL)[0]
        print(name + '|' + ext)

        if(ext == '.dcm'):
            #dcm_file = sftp.open(dcmURL)

            sftpattrs = sftp.stat(dcmURL)
            print(sftpattrs.st_mtime)
            fileMtime = datetime.fromtimestamp(sftpattrs.st_mtime)

            #gendate = str(fileMtime.strftime('%Y%m%d'))
            #print(gendate)
            file_date = str(fileMtime.strftime('%Y-%m-%d %H:%M:%S'))

            #modality = ParsingDcm(dcm_file)
            #print(modality)
            filename = os.path.basename(dcmURL)
            localpath = '/mod/dev/backend/apiroot/pacs/data/am53/dcm/'+gendate+'/' + filename
            print('localpath:' + localpath)

            if inputDate < fileMtime:
                sftp.get(dcmURL, localpath)

                print('새로운 DCM 파일을 복사하였습니다.[' + str(file_date) + '] totalcount:'+str(total_count))


                # convert_check.php 실행 (데이터베이스에  전송파일명 저장)
                print("to write databse")
                # to write remote server's database
                hid='am53'
                db_url='http://am53.modhospital.kr:7002/pacs/convert_check.php'
                dcmURL=localpath
                request(db_url + "?localdcm=" + dcmURL + "&remotedcm="+localpath+"&gendate=" + gendate + "&hid=" + hid,
                        read_dcm_dic, gendate, file_date)
                print("file copy success!")
                total_count += 1



    sftp.close()
    transport.close()



def main():
    global total_count
    global today


    # 현재일 계산
    # current_datetime = datetime.now()
    # now = datetime(2020, 9, 12, 00, 00, 00)
    current_datetime = datetime(2021, 5, 14, 00, 00, 00)

    today = str(current_datetime.strftime('%Y%m%d'))
    today_Y = int(current_datetime.strftime('%Y'))
    today_M = int(current_datetime.strftime('%m'))
    today_D = int(current_datetime.strftime('%d'))

    now = datetime(today_Y, today_M, today_D, 00, 00, 00)

    read_dcm_dic = readConvertLog()
    print('convert log file find')

    last_file_date = read_dcm_dic.get('last_mtime')
    get_total_count = read_dcm_dic.get('total_count')


    if get_total_count == None:
        total_count = 0

    else:
        total_count = int(get_total_count)

    if last_file_date == None:

        #work_day = str(now.strftime('%Y-%m-%d %H:%M:%S'))

        work_day = "2021-05-14 00:00:00" #test

        workDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')
        inputDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')


    else:
        #work_day = str(now.strftime('%Y-%m-%d %H:%M:%S'))

        work_day = "2021-05-14 00:00:00" #test

        workDate = datetime.strptime(work_day, '%Y-%m-%d %H:%M:%S')

        inputDate = datetime.strptime(last_file_date, '%Y-%m-%d %H:%M:%S')





    #현재날짜 또는 마지막 업데이트 기록을 근거로 새로운 dcm 파일만 가져온다.
    receivetodcm('',read_dcm_dic,inputDate,workDate)


main()
